#include <iostream>
#include <cstdio>
#include <cstdlib>
#include <cmath>
#include <ctime>
#include <cstring>
#include <cassert>
#include <algorithm>
#include <vector>
#include <set>
#include <map>
#include <bitset>
#include <stack>
#include <queue>
#include <deque>
#include <complex>

using namespace std;

#define pb push_back
#define mp make_pair
#define sz(s) int((s).size())
#define len(s) int((s).size())
#define all(s) (s).begin(), (s).end()
#ifdef _WIN32
#define LLD "%I64d"
#else
#define LLD "%lld"
#endif
#ifdef LOCAL42
#define eprintf(...) fprintf(stderr, __VA_ARGS__)
#else
#define eprintf(...) 42
#endif
#define y0 yy0
#define y1 yy1
#define next _next
#define prev _prev
#define rank _rank
#define link _link
#define hash _hash
#define fs first
#define sc second

typedef long long ll;
typedef long long llong;
typedef long long int64;
typedef unsigned int uint;
typedef long double ld;
typedef unsigned long long ull;
typedef unsigned long long ullong;
typedef unsigned long long lint;
typedef pair<int, int> pii;
typedef vector<int> vi;

const int inf = int(1e9);
const double eps = 1e-9;
const double pi = 4 * atan(double(1));
const int N = 55;

struct edge {

	int a, b, c;

};

bool operator < (const edge &a, const edge &b) {
	return a.c > b.c;
}

edge e[N * N];
vector<edge> ans;
int prev[N], rank[N], d[N];
vector<pii> g[N];
int c[N][N];

int get(int a) {
	if (prev[a] != a) {
		prev[a] = get(prev[a]);
	}
	return prev[a];
}

inline void merge(int a, int b) {
	if (rank[a] < rank[b]) {
		swap(a, b);
	}
	prev[b] = a;
	if (rank[a] == rank[b]) {
		++rank[a];
	}
}

void dfs(int v, int pv, int val) {
	d[v] = val;
	for (int i = 0; i < sz(g[v]); ++i) {
		if (g[v][i].fs != pv) {
			dfs(g[v][i].fs, v, min(val, g[v][i].sc));
		}
	}
}

int main() {
#ifdef LOCAL42
#define TASK "M"
	freopen(TASK ".in", "r", stdin);
	freopen(TASK ".out", "w", stdout);
#else

#endif
	int n;
	scanf("%d", &n);
	for (int i = 0; i < n; ++i) {
		for (int j = 0; j < n; ++j) {
			scanf("%d", &c[i][j]);
			e[i * n + j].c = c[i][j];
			e[i * n + j].a = i;
			e[i * n + j].b = j;
		}
	}
	sort(e, e + n * n);
	for (int i = 0; i < n; ++i) {
		prev[i] = i;
		rank[i] = 1;
	}
	for (int i = 0; i < n * n; ++i) {
		int a = get(e[i].a), b = get(e[i].b);
		if (a != b) {
			g[e[i].a].pb(mp(e[i].b, e[i].c));
			g[e[i].b].pb(mp(e[i].a, e[i].c));
			merge(a, b);
			ans.pb(e[i]);
		}
	}
	for (int i = 0; i < n; ++i) {
		dfs(i, -1, inf);
		for (int j = 0; j < n; ++j) {
			if (i != j && d[j] != c[i][j]) {
				puts("NO");
				return 0;
			}
		}
	}
	puts("YES");
	printf("%d\n", sz(ans));
	for (int i = 0; i < sz(ans); ++i) {
		printf("%d %d %d\n", ans[i].a + 1, ans[i].b + 1, ans[i].c);
	}
	return 0;
}
